'use strict';
/*jshint sub:true*/

angular.module('genisis').controller('ssoCtrl', ['$scope', '$rootScope',
  'user', '$location',
  function ($scope, $rootScope, $user, $location) {

    $scope.ssoMessage = 'Please wait, processing SSO authentication.';

    //if they are logged in push them into the requests
    if ($user.loggedIn()) {
      $location.path('/requests');
      $location.replace();
    }

    // Well move to a service later
    $scope.getClientSDn = function () {
      var req = new XMLHttpRequest();
      req.open('GET', document.location, false);
      req.send(null);
      var header = req.getResponseHeader('SSL_CLIENT_S_DN');

      return header;
    };

    $scope.parseClientSDn = function (ssl_client_s_din) {
      var clientSDn = {};
      // separate by spaces first
      if (ssl_client_s_din) {
        var headerArray = ssl_client_s_din.split('/');
        headerArray.splice(headerArray.indexOf(''), 1);
        for (var i = 0; i < headerArray.length; i++) {
          var arr = headerArray[i].split('=');
          clientSDn[arr[0]] = arr[1];
        }
        return clientSDn;
      } else {
        return null;
      }
    };

    $scope.validateClientSDn = function (clientSDn) {
      if (clientSDn['UID'] && clientSDn['UID'].length > 0 && clientSDn[
          'UID'].indexOf('@') >=
        0) {
        return true;
      }

      return false;
    };

    $scope.validateSSO = function (clientSDn) {
      if (clientSDn) {
        var parsedClientSDn = $scope.parseClientSDn(clientSDn);
        if ($scope.validateClientSDn(parsedClientSDn)) {
          $user.login(parsedClientSDn['UID']).then(function (signedIn) {
            if (!signedIn) {
              $scope.ssoMessage =
                'SSO authenticated successfully, but you ' +
                'are not authorized to access GENISIS application, please ' +
                'contact GENISIS administrators and reload ' +
                'this page when ready.';
              return false;
            }
            return true;
          });
        } else {
          $scope.ssoMessage = 'Failed to validate SSO credentials, ' +
            'please reload this page and try again. ' +
            'If this issue persists, please contact ' +
            'GENISIS administrators....';
          return false;
        }
      } else {
        $scope.ssoMessage = 'Failed to connect to VA ' +
          'SSO services, ' +
          'please reload this page and try again. ' +
          'If this issue persists, please contact ' +
          'GENISIS administrators....';
        return false;
      }

    };

    $scope.validateSSO($scope.getClientSDn());

  }
]);